/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.data;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.neighborhood.IBlockNeighborhood;
import mod.chiselsandbits.api.neighborhood.IBlockNeighborhoodBuilder;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.api.variant.state.IStateVariant;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.block.entities.ChiseledBlockEntity;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModelManager;
import mod.chiselsandbits.client.model.baked.chiseled.FluidRenderingManager;
import mod.chiselsandbits.client.model.baked.simple.CombinedModel;
import mod.chiselsandbits.client.model.baked.simple.NullBakedModel;
import mod.chiselsandbits.platforms.core.client.models.data.IModelDataBuilder;
import mod.chiselsandbits.platforms.core.client.models.data.IModelDataManager;
import mod.chiselsandbits.platforms.core.client.rendering.type.IRenderTypeManager;
import mod.chiselsandbits.profiling.ProfilingManager;
import mod.chiselsandbits.registrars.ModModelProperties;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;

public class ChiseledBlockModelDataExecutor {
    private static ExecutorService recalculationService;

    public static void updateModelDataCore(ChiseledBlockEntity tileEntity, Runnable onCompleteCallback) {
        ChiseledBlockModelDataExecutor.ensureThreadPoolSetup();
        IBlockNeighborhood neighborhood = IBlockNeighborhoodBuilder.getInstance().build(direction -> {
            class_2680 state = Objects.requireNonNull(tileEntity.method_10997()).method_8320(tileEntity.method_11016().method_10081(direction.method_10163()));
            Optional<IStateVariant> additionalStateInfo = IStateVariantManager.getInstance().getStateVariant(state, Optional.ofNullable(tileEntity.method_10997().method_8321(tileEntity.method_11016().method_10081(direction.method_10163()))));
            return new BlockInformation(state, additionalStateInfo);
        }, direction -> {
            class_2586 otherTileEntity = Objects.requireNonNull(tileEntity.method_10997()).method_8321(tileEntity.method_11016().method_10081(direction.method_10163()));
            if (otherTileEntity instanceof IAreaAccessor) {
                return (IAreaAccessor)otherTileEntity;
            }
            return null;
        });
        ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            LinkedHashMap renderTypedModels = Maps.newLinkedHashMap();
            try (IProfilerSection ignored1 = ProfilingManager.getInstance().withSection("Extract model data from data");){
                class_1921 currentType = IRenderTypeManager.getInstance().getCurrentRenderType().orElse(null);
                IRenderTypeManager.getInstance().setCurrentRenderType(null);
                try (IProfilerSection ignored2 = ProfilingManager.getInstance().withSection("Known render layer model building");){
                    for (class_1921 chunkBufferLayer : class_1921.method_22720()) {
                        Object baked;
                        block54: {
                            ChiselRenderType solidType = ChiselRenderType.fromLayer(chunkBufferLayer, false);
                            ChiselRenderType fluidType = ChiselRenderType.fromLayer(chunkBufferLayer, true);
                            IRenderTypeManager.getInstance().setCurrentRenderType(chunkBufferLayer);
                            if (tileEntity.getStatistics().getStateCounts().isEmpty() || tileEntity.getStatistics().getStateCounts().size() == 1 && tileEntity.getStatistics().getStateCounts().containsKey(BlockInformation.AIR)) continue;
                            boolean requiredDuringRendering = false;
                            for (BlockInformation state : tileEntity.getStatistics().getStateCounts().keySet()) {
                                if (!solidType.isRequiredForRendering(state) && !fluidType.isRequiredForRendering(state)) continue;
                                requiredDuringRendering = true;
                            }
                            baked = NullBakedModel.instance;
                            if (requiredDuringRendering) {
                                try (IProfilerSection ignored3 = ProfilingManager.getInstance().withSection("Known render layer model building for: " + solidType.name() + " and " + fluidType.name());){
                                    IProfilerSection ignored4;
                                    if (FluidRenderingManager.getInstance().isFluidRenderType(chunkBufferLayer)) {
                                        ignored4 = ProfilingManager.getInstance().withSection("Combined model building");
                                        try {
                                            ChiseledBlockBakedModel fluidModel;
                                            ChiseledBlockBakedModel solidModel;
                                            try (IProfilerSection ignored5 = ProfilingManager.getInstance().withSection("Solid");){
                                                solidModel = ChiseledBlockBakedModelManager.getInstance().get(tileEntity, tileEntity.getStatistics().getPrimaryState(), solidType, neighborhood::getBlockInformation, neighborhood::getAreaAccessor, tileEntity.method_11016());
                                            }
                                            try (IProfilerSection ignored5 = ProfilingManager.getInstance().withSection("Fluid");){
                                                fluidModel = ChiseledBlockBakedModelManager.getInstance().get(tileEntity, tileEntity.getStatistics().getPrimaryState(), fluidType, neighborhood::getBlockInformation, neighborhood::getAreaAccessor, tileEntity.method_11016());
                                            }
                                            ignored5 = ProfilingManager.getInstance().withSection("Model combining");
                                            try {
                                                baked = solidModel.isEmpty() ? fluidModel : (fluidModel.isEmpty() ? solidModel : new CombinedModel(solidModel, fluidModel));
                                                break block54;
                                            }
                                            finally {
                                                if (ignored5 != null) {
                                                    ignored5.close();
                                                }
                                            }
                                        }
                                        finally {
                                            if (ignored4 != null) {
                                                ignored4.close();
                                            }
                                        }
                                    }
                                    ignored4 = ProfilingManager.getInstance().withSection("Singular model building");
                                    try {
                                        baked = ChiseledBlockBakedModelManager.getInstance().get(tileEntity, tileEntity.getStatistics().getPrimaryState(), ChiselRenderType.fromLayer(chunkBufferLayer, false), neighborhood::getBlockInformation, neighborhood::getAreaAccessor, tileEntity.method_11016());
                                    }
                                    finally {
                                        if (ignored4 != null) {
                                            ignored4.close();
                                        }
                                    }
                                }
                            }
                        }
                        renderTypedModels.put(chunkBufferLayer, baked);
                    }
                }
                IRenderTypeManager.getInstance().setCurrentRenderType(currentType);
            }
            CombinedModel unknownRenderTypeModel = new CombinedModel((class_1087[])renderTypedModels.values().stream().filter(model -> model != NullBakedModel.instance).toArray(class_1087[]::new));
            return IModelDataBuilder.create().withInitial(ModModelProperties.UNKNOWN_LAYER_MODEL_PROPERTY, unknownRenderTypeModel).withInitial(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY, renderTypedModels).build();
        }, recalculationService).thenAcceptAsync(tileEntity::setModelData, (Executor)recalculationService)).thenRunAsync(onCompleteCallback, recalculationService)).thenRunAsync(() -> {
            if (class_310.method_1551().field_1687 == tileEntity.method_10997()) {
                IModelDataManager.getInstance().requestModelDataRefresh(tileEntity);
                Objects.requireNonNull(class_310.method_1551().field_1687).method_8413(tileEntity.method_11016(), tileEntity.method_11010(), tileEntity.method_11010(), 8);
            }
        }, (Executor)class_310.method_1551());
    }

    private static synchronized void ensureThreadPoolSetup() {
        if (recalculationService == null) {
            ClassLoader classLoader = ChiselsAndBits.class.getClassLoader();
            AtomicInteger genericThreadCounter = new AtomicInteger();
            recalculationService = Executors.newFixedThreadPool(IClientConfiguration.getInstance().getModelBuildingThreadCount().get(), runnable -> {
                Thread thread = new Thread(runnable);
                thread.setContextClassLoader(classLoader);
                thread.setName(String.format("Chisels and Bits Model builder #%s", genericThreadCounter.incrementAndGet()));
                thread.setDaemon(true);
                return thread;
            });
        }
    }
}

